﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;

namespace MVC_App.Validation
{
	public class TreeNodeChecker<TEntity>
	{
		public TreeNodeChecker(IErrorTracker errorTracker, TEntity value)
		{
			_errorTracker = errorTracker;
			_value = value;
		}

		private readonly IErrorTracker _errorTracker;
		private readonly TEntity _value;

		public TreeNodeChecker<TProperty> MoveToNode<TProperty>(Expression<Func<TEntity, TProperty>> expr)
			where TProperty : class
		{
			return new TreeNodeChecker<TProperty>(_errorTracker.Descend(GetName(expr)), GetValue(expr));
		}

		public ValidatingNode<TProperty> Validate<TProperty>(Expression<Func<TEntity, TProperty>> expr)
		{
			return new ValidatingNode<TProperty>(GetValue(expr), new ErrorWrapper(_errorTracker, new Dictionary<string, string> { { GetName(expr), null} }));
		}

		// Namen des Propertys ermitteln, das durch den Func<> addressiert wird
		private static string GetName<U>(Expression<Func<TEntity, U>> expr)
		{
			var node = expr.Body as MemberExpression;
			if (ReferenceEquals(null, node))
				throw new InvalidOperationException("Expression must be member access");
			return node.Member.Name;
		}

		// Wert des Propertys ermitteln, das durch den Func<> addressiert wird.
		// Aber nur wenn wir auch selbst noch valide sind.
		private TProperty GetValue<TProperty>(Expression<Func<TEntity, TProperty>> expr)
		{
			return _value == null ? default(TProperty) : expr.Compile()(_value);
		}
	}
}